<?php $__env->startSection('content'); ?>
    <?php if(isset($error)) { ?>
    <div class="row justify-content-center ins-seven">
        <div class="col-md-6">
            <div class="alert alert-danger">
                <strong><?php echo e($error); ?></strong>
            </div>
        </div>
    </div>
    <?php } ?>
    <div class="card">
        <div class="card-body">
            <div class="text-center pt-2">
                <img src="<?php echo e(asset('assets/install/images/logo.svg')); ?>" alt="" />
            </div>
            <div class="page-title">
                <h4> <?php echo e(__('Installation')); ?> </h4>
            </div>
            <p class="ins-p-1">
                <strong><?php echo e(__('Congratulations!! The installation was successfully')); ?></strong>
            </p>
            <p class="ins-p-2">
                <?php echo e(__("Before you start using your application, make it yours. Set your application name and title, admin login email and password. Remember the login credentials which you will need later on for signing into your account. After this step, you will be redirected to application's login page.")); ?>

            </p>
            <form class="form-horizontal form-groups" method="post" action="<?php echo e(route('finalizing_setup')); ?>">
                <?php echo csrf_field(); ?>
                <div class="form-group mb-2">
                    <label class="col-sm-3 control-label"><?php echo e(__('System Name')); ?></label>

                    <input type="text" class="form-control eForm-control" name="system_name" required autofocus>
                    <small class="text-muted">
                        <?php echo e(__('The name of your application')); ?>

                    </small>
                </div>
                <div class="form-group mb-2">
                    <label class="col-sm-3 control-label"><?php echo e(__('Your name')); ?></label>

                    <input type="text" class="form-control eForm-control" name="admin_name" placeholder="Ex: John Doe"
                        required>
                    <small class="text-muted">
                        <?php echo e(__('Full name of Administrator')); ?>

                    </small>
                </div>
                <div class="form-group mb-2">
                    <label class="col-sm-3 control-label"><?php echo e(__('Your Email')); ?></label>

                    <input type="email" class="form-control eForm-control" name="admin_email"
                        placeholder="Ex: john@example.com" required>
                    <small class="text-muted">
                        <?php echo e(__('Email address for administrator login')); ?>

                    </small>
                </div>
                <div class="form-group mb-2">
                    <label class="col-sm-3 control-label"><?php echo e(__('Password')); ?></label>

                    <input type="password" class="form-control eForm-control" name="admin_password" placeholder="" required>
                    <small class="text-muted">
                        <?php echo e(__('Admin login password')); ?>

                    </small>
                </div>
                <div class="form-group mb-2">
                    <label class="col-sm-3 control-label"><?php echo e(__('Your Address')); ?></label>

                    <input type="text" class="form-control eForm-control" name="admin_address"
                        placeholder="Ex: Your Address" required>
                    <small class="text-muted">
                        <?php echo e(__('Address of Administrator')); ?>

                    </small>
                </div>
                <div class="form-group mb-2">
                    <label class="col-sm-3 control-label"><?php echo e(__('Your Phone')); ?></label>

                    <input type="text" class="form-control eForm-control" name="admin_phone"
                        placeholder="Ex: +9020040060" required>
                    <small class="text-muted">
                        <?php echo e(__('Phone of Administrator')); ?>

                    </small>
                </div>
                <div class="form-group mb-2">
                    <label class="col-sm-3 control-label"><?php echo e(__('TimeZone')); ?></label>

                    <select class="form-select form-control eChoice-multiple-with-remove" id="timezone" name="timezone">
                        <?php $tzlist = DateTimeZone::listIdentifiers(DateTimeZone::ALL); ?>
                        <?php foreach ($tzlist as $tz): ?>
                        <option value="<?php echo e($tz); ?>" <?php echo e($tz == 'Asia/Dhaka' ? 'selected' : ''); ?>>
                            <?php echo e($tz); ?></option>
                        <?php endforeach; ?>
                    </select>
                    <small class="text-muted">
                        <?php echo e(__('Choose System TimeZone')); ?>

                    </small>
                </div>

                <div class="d-flex align-items-center justify-content-between pt-2">
                    <div>
                        <div id="loader" class="ins-seven mt-2">
                           
                        </div>
                    </div>
                    <button type="submit" id="install_button" class="ins-btn">
                        <?php echo e(__('Set me up')); ?>

                    </button>
                </div>
            </form>

            <ul class="ins-step">
                <li class="active"></li>
                <li class="active"></li>
                <li class="active"></li>
                <li class="active"></li>
                <li class="active"></li>
                <li class="active"></li>
            </ul>
            <span> <?php echo e(__('Step-5')); ?> </span>
            <div class="text-center">
                <p><?php echo e(__('Need any help?')); ?> <a href="https://creativeitem.com/" target="_blank"><?php echo e(__('Contact Us')); ?></a></p>
            </div>
        </div>
    </div>
    <!-- jQuery -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('install.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\v1\atlas\resources\views/install/step5.blade.php ENDPATH**/ ?>