<?php $__env->startSection('title', get_phrase('System Settings')); ?>
<?php $__env->startSection('admin_layout'); ?>

<div class="ol-card radius-8px">
    <div class="ol-card-body my-2 py-20px px-20px">
        <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
            <h4 class="title fs-16px">
                <i class="fi-rr-settings-sliders me-2"></i>
                <?php echo e(get_phrase('System Settings')); ?>

            </h4>
        </div>
    </div>
</div>

<div class="row mt-3">
    <div class="col-sm-6">
        <div class="ol-card">
            <div class="ol-card-body p-3 py-4">
            <form action="<?php echo e(route('admin.system-setting-update')); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="mb-3">
                    <label for="system_title" class="form-label ol-form-label"> <?php echo e(get_phrase('Website name')); ?> </label>
                    <input type="text" class="form-control ol-form-control" name="system_title" id="system_title" value="<?php echo e(get_settings('system_title')); ?>" required>
                </div>
                <div class="mb-3">
                    <label for="system_email" class="form-label ol-form-label"> <?php echo e(get_phrase('Website Email')); ?> </label>
                    <input type="text" class="form-control ol-form-control" name="system_email" id="system_email" value="<?php echo e(get_settings('system_email')); ?>" required>
                </div>
                <div class="mb-3">
                    <label for="keyword" class="form-label ol-form-label"> <?php echo e(get_phrase('Website keywords')); ?> </label>
                    <input type="text" class="form-control ol-form-control" name="keyword" id="keyword" value="<?php echo e(get_settings('keyword')); ?>" required>
                </div>
                <div class="mb-3">
                    <label for="website_description" class="form-label ol-form-label"> <?php echo e(get_phrase('Website Description')); ?> </label>
                    <textarea name="website_description" id="website_description" class="form-control ol-form-control" rows="5"><?php echo e(get_settings('website_description')); ?></textarea>
                </div>
                <div class="mb-3">
                    <label for="author" class="form-label ol-form-label"> <?php echo e(get_phrase('Author')); ?> </label>
                    <input type="text" class="form-control ol-form-control" name="author" id="author" value="<?php echo e(get_settings('author')); ?>" required>
                </div>
                <div class="mb-3">
                    <label for="system_currency" class="form-label ol-form-label"> <?php echo e(get_phrase('System Currency')); ?> </label>
                    <select name="system_currency" id="system_currency" class="form-control ol-form-control ol-select2" required>
                        <?php $__currentLoopData = App\Models\Currency::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item->id); ?>" <?php echo e(get_settings('system_currency') == $item->id?'selected':''); ?>> <?php echo e($item->code); ?> </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="currency_position" class="form-label ol-form-label"> <?php echo e(get_phrase('Currency Position')); ?> </label>
                    <select name="currency_position" id="currency_position" class="form-control ol-form-control ol-select2" required>
                        <option value="left" <?php echo e(get_settings('currency_position') == 'left'?'selected':''); ?>> <?php echo e(get_phrase('Left')); ?> </option>
                        <option value="right" <?php echo e(get_settings('currency_position') == 'right'?'selected':''); ?>> <?php echo e(get_phrase('Right')); ?> </option>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="address" class="form-label ol-form-label"> <?php echo e(get_phrase('Address')); ?> </label>
                    <input type="text" class="form-control ol-form-control" name="address" id="address" value="<?php echo e(get_settings('address')); ?>" required>
                </div>
                <div class="mb-3">
                    <label for="phone" class="form-label ol-form-label"> <?php echo e(get_phrase('Phone Number')); ?> </label>
                    <input type="text" class="form-control ol-form-control" name="phone" id="phone" value="<?php echo e(get_settings('phone')); ?>" required>
                </div>
                <div class="mb-3">
                    <label for="language" class="form-label ol-form-label"> <?php echo e(get_phrase('System Language')); ?> </label>
                    <select name="language" id="language" class="form-control ol-form-control ol-select2"  required>
                        <option value="">
                            <?php echo e(get_phrase('Select a system language')); ?>

                        </option>

                        <?php $__currentLoopData = App\Models\Language::select('name')->groupBy('name')->get();; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($language->name); ?>" <?php if(get_settings('language')==$language->name): ?> <?php echo e('selected'); ?> <?php endif; ?>>
                            <?php echo e(get_phrase(ucfirst($language->name ))); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="country" class="form-label ol-form-label"> <?php echo e(get_phrase('Country')); ?> </label>
                    <select name="country" id="country" class="form-control ol-form-control ol-select2"  required>
                        <option value="">
                            <?php echo e(get_phrase('Select a Country')); ?>

                        </option>

                        <?php $__currentLoopData = App\Models\Country::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($country->id); ?>" <?php if(get_settings('country_id')==$country->id): ?> <?php echo e('selected'); ?> <?php endif; ?>>
                            <?php echo e(get_phrase(ucfirst($country->name ))); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="purchase_code" class="form-label ol-form-label"> <?php echo e(get_phrase('Purchase Code')); ?> </label>
                    <input type="text" class="form-control ol-form-control" name="purchase_code" id="purchase_code" value="<?php echo e(get_settings('purchase_code')); ?>" required>
                </div>
                <div class="mb-3">
                    <label for="verification" class="form-label ol-form-label"> <?php echo e(get_phrase('Email Verification')); ?> </label>
                    <select name="signup_email_verification" id="verification" class="form-control ol-form-control"  required>
                        <option value=""><?php echo e(get_phrase('Select email verification')); ?> </option>
                        <option value="1" <?php if(get_settings('signup_email_verification') == 1): ?> selected <?php endif; ?>>
                            <?php echo e(get_phrase('Enable')); ?>

                        </option>
                        <option value="0" <?php if(get_settings('signup_email_verification') == 0): ?> selected <?php endif; ?>>
                            <?php echo e(get_phrase('Disable')); ?>

                        </option>  
                    </select>
                </div>
                <div class="mb-3">
                    <label for="map_access_token" class="form-label ol-form-label"><?php echo e(get_phrase('Map access token')); ?></label>
                    <input type="text" class="form-control ol-form-control" value="<?php echo e(get_settings('map_access_token')); ?>" id="map_access_token" name = "map_access_token" required>
                </div>
                <div class="mb-3">
                    <label for="max_zoom_level" class="form-label ol-form-label"><?php echo e(get_phrase('Max zoom level')); ?></label>
                    <input type="text" class="form-control ol-form-control" value="<?php echo e(get_settings('max_zoom_level')); ?>" id="max_zoom_level" name = "max_zoom_level" required>
                </div>
                <div class="mb-3">
                    <label for="default_location" class="form-label ol-form-label"><?php echo e(get_phrase('Default location')); ?></label>
                    <input type="text" class="form-control ol-form-control" value="<?php echo e(get_settings('default_location')); ?>" id="default_location" name = "default_location" required>
                </div>
                <div class="mb-3">
                    <label for="footer_text" class="form-label ol-form-label"><?php echo e(get_phrase('Footer Copyright Text')); ?></label>
                    <input type="text" name="footer_text" id="footer_text" class="form-control ol-form-control" value="<?php echo e(get_settings('footer_text')); ?>">
                </div>
                <div class="mb-3">
                    <label for="footer_copyright_text" class="form-label ol-form-label"><?php echo e(get_phrase('Footer  Text')); ?></label>
                    <input type="text" name="footer_copyright_text" id="footer_copyright_text" class="form-control ol-form-control" value="<?php echo e(get_settings('footer_copyright_text')); ?>">
                </div>
                <div class="mb-3">
                    <label for="footer_copyright_text" class="form-label ol-form-label"><?php echo e(get_phrase('Timezone')); ?></label>
                    <select class="form-control ol-form-control ol-select2" id="timezone" name="timezone">
                        <?php $tzlist = DateTimeZone::listIdentifiers(DateTimeZone::ALL); ?>
                        <?php foreach ($tzlist as $tz): ?>
                            <option value="<?php echo e($tz); ?>" <?php echo e(get_settings('timezone') == $tz ? 'selected' : ''); ?>>
                                <?php echo e($tz); ?>

                            </option>
                        <?php endforeach; ?>
                    </select>
                    
                </div>

                <button type="submit" class="btn ol-btn-primary fs-14px"> <?php echo e(get_phrase('Update')); ?> </button>
            </form>
            </div>
        </div>
    </div>
    <div class="col-sm-6">
        <div class="ol-card mb-2">
            <div class="ol-card-body p-3">
                <form  action="<?php echo e(route('admin.product.update')); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label for="file" class="form-label ol-form-label"> <?php echo e(get_phrase('Update Product')); ?>* </label>
                        <input type="file" class="form-control ol-form-control" name="file" id="file" required>
                    </div>
                    <button type="submit" class="btn ol-btn-primary fs-14px"> <?php echo e(get_phrase('Update')); ?> </button>
                </form>
            </div>
        </div>
        <div class="ol-card">
            <div class="ol-card-body p-3 py-4">
                <form action="<?php echo e(route('admin.system-setting-update-social')); ?>" method="post" enctype="multipart/form-data\">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label for="facebook" class="form-label ol-form-label"> <?php echo e(get_phrase('Facebook Link')); ?>* </label>
                        <input type="text" class="form-control ol-form-control" name="facebook" id="facebook" value="<?php echo e(get_settings('facebook')); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="twitter" class="form-label ol-form-label"> <?php echo e(get_phrase('Twitter Link')); ?>* </label>
                        <input type="text" class="form-control ol-form-control" name="twitter" id="twitter" value="<?php echo e(get_settings('twitter')); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="linkedin" class="form-label ol-form-label"> <?php echo e(get_phrase('Linkedin Link')); ?>* </label>
                        <input type="text" class="form-control ol-form-control" name="linkedin" id="linkedin" value="<?php echo e(get_settings('linkedin')); ?>" required>
                    </div>
                    <button type="submit" class="btn ol-btn-primary fs-14px"> <?php echo e(get_phrase('Update')); ?> </button>
                </form>
            </div>
        </div>
       
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\1.1Atlas\resources\views/admin/setting/system_setting.blade.php ENDPATH**/ ?>