<meta http-equiv="x-ua-compatible" content="ie=edge" />
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

<?php echo e(config(['app.name' => get_settings('system_title')])); ?>


<?php
if(isset($type) && isset($listing_id)){
       if($type == 'beauty'){
            $seo_field = App\Models\BeautyListing::where('id', $listing_id)->first();
        }elseif($type == 'car'){
            $seo_field = App\Models\CarListing::where('id', $listing_id)->first();
        }elseif($type == 'real-estate'){
            $seo_field = App\Models\RealEstateListing::where('id', $listing_id)->first();
        }elseif($type == 'hotel'){
            $seo_field = App\Models\HotelListing::where('id', $listing_id)->first();
        }elseif($type == 'restaurant'){
            $seo_field = App\Models\RestaurantListing::where('id', $listing_id)->first();
        }
}else{
    $current_route = Route::currentRouteName();
    $seo_field = App\Models\SeoField::where('name_route', $current_route);
    $seo_field = $seo_field->firstOrNew();
   
}
 
?>

<?php if(!empty($seo_field['meta_title'])): ?>
<title><?php echo e($seo_field['meta_title']); ?></title>
<?php else: ?>
<title><?php echo $__env->yieldPushContent('title'); ?> | <?php echo e(config('app.name')); ?></title>
<?php endif; ?>
<meta name="keywords" content="<?php echo e($seo_field['mets_keywords'] ?? ''); ?>">
<meta name="description" content="<?php echo e($seo_field['meta_description'] ?? ''); ?>">
<meta name="robots" content="<?php echo e($seo_field['meta_robot'] ?? ''); ?>">
<link rel="canonical" href="<?php echo e($seo_field['canonical_url'] ?? ''); ?>" />
<link rel="custom" href="<?php echo e($seo_field['custom_url'] ?? ''); ?>" />
<meta name="mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-title" content="<?php echo e($seo_field['meta_title'] ?? ''); ?>">
<?php if(isset($seo_field['json_ld'])): ?>
<?php echo removeScripts($seo_field['json_ld'] != strip_tags($seo_field['json_ld']) ? $seo_field['json_ld']:''); ?>

<?php endif; ?>

<meta property="og:title" content="<?php echo e($seo_field['og_title'] ?? ''); ?>" />
<meta property="og:description" content="<?php echo e($seo_field['og_description'] ?? ''); ?>" />
<?php if(isset($type) && isset($listing_id)): ?>
<meta property="og:image" content="<?php echo e(get_image('storage/og_image/'.$seo_field['og_image'])); ?>" />
<?php else: ?>
<meta property="og:image" content="<?php echo e((file_exists(public_path('uploads/seo-og-images/' . ($seo_field->og_image ?? ''))) && is_file(public_path('uploads/seo-og-images/' . ($seo_field->og_image ?? '')))) ? asset('uploads/seo-og-images/' . $seo_field->og_image) : asset('image/placeholder.png')); ?>" />
<?php endif; ?>
<?php echo $__env->yieldPushContent('meta'); ?>
<?php /**PATH C:\MAMP\htdocs\1.1Atlas\resources\views/layouts/seo.blade.php ENDPATH**/ ?>