<h3 class="title fs-16px d-flex mb-3"> <?php echo e(get_phrase('Profile Information')); ?> </h3>

<form method="post" action="<?php echo e(route('profile.update')); ?>" class="mt-6 space-y-6" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <?php echo method_field('patch'); ?>
    <div class="row">
        <div class="col-sm-6">
        
            <div class="mb-2">
                <label for="name" class="form-label ol-form-label"> <?php echo e(get_phrase('User Name')); ?> </label>
                <input type="text" class="form-control ol-form-control" name="name" id="name" placeholder="<?php echo e(get_phrase('Enter user name')); ?>" value="<?php echo e($user->name); ?>" required>
            </div>

            <div class="mb-2">
                <label for="email" class="form-label ol-form-label"> <?php echo e(get_phrase('User Email')); ?> </label>
                <input type="text" class="form-control ol-form-control" name="email" id="email" placeholder="<?php echo e(get_phrase('Enter user email')); ?>" value="<?php echo e($user->email); ?>" required>
            </div>

            <div class="mb-2">
                <label for="image" class="form-label ol-form-label"> <?php echo e(get_phrase('User Image')); ?> </label>
                <input type="file" class="form-control ol-form-control" name="image" id="image">
            </div>

            <div class="flex items-center gap-4">
                <button type="submit" class="btn btn-primary fs-14px"> <?php echo e(get_phrase('Save')); ?> </button>
            </div>
        </div>
        <div class="col-sm-6 pt-4">
            <img class="rounded mt-2" src="<?php echo e(get_image('storage/users/'.$user->image)); ?>" height="200px" alt="">
        </div>
    </div>
</form>
<?php /**PATH C:\MAMP\htdocs\v1\atlas\resources\views/admin/profile/partials/update-profile-information-form.blade.php ENDPATH**/ ?>