<?php echo $__env->make('frontend.sidebar_top', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php 
$min_price =  App\Models\HotelListing::min('price') ?? 0;
$max_price =  App\Models\HotelListing::max('price') ?? 0;
$cities = App\Models\HotelListing::select('city')->groupBy('city')->get();
$countries = App\Models\HotelListing::select('country')->groupBy('country')->get();
isset($searched_bedroom) ? '' : ($searched_bedroom = []);
isset($searched_bathroom) ? '' : ($searched_bathroom = []);
isset($status_type) ? '' : ($status_type = []);
$numbers = ['1', '2', '3', '4', '5'];
?>

<form class="sidebar-accordion-area" id="filter-form" action="<?php echo e(route('ListingsFilter')); ?>" method="get">
    <div class="sidebar-title mb-24 d-flex align-items-center justify-content-between flex-wrap">
        <h3 class="title"><?php echo e(get_phrase('Filters')); ?></h3>
        <a href="javascript:;" onclick="resetForm(event)" class="clear d-none"><?php echo e(get_phrase('Clear')); ?></a>
    </div>
    <input type="hidden" name="type" value="hotel">
    <input type="hidden" name="view" value="<?php echo e($view); ?>">
    <ul class="sidebar-accordion">
        <li class="sidebar-accordion-li">
            <a href="javascript:void(0);">
                <span><?php echo e(ucwords($type) . ' ' . get_phrase('Category')); ?></span>
                <img src="<?php echo e(asset('assets/frontend/images/icons/angle-down-black-20.svg')); ?>" alt="">
            </a>
            <ul class="sidebar-accordion-menu nBlock" id="categoryList" >
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $categoryCount = App\Models\HotelListing::where('category', $category->id)->count();
                    ?>
                    <li class="<?php echo e($index >= 6 ? 'hidden' : ''); ?>">
                        <a href="<?php echo e(route('ListingsFilter')); ?>?type=hotel&view=<?php echo e($view); ?>&category=<?php echo e($category->id); ?>" class="filter <?php echo e((isset($category_type) && $category->id == $category_type) ? 'active' : ''); ?>" for="category<?php echo e($category->id); ?>" >
                            <input class="d-none" type="radio" name="category" value="<?php echo e($category->id); ?>" id="category<?php echo e($category->id); ?>" <?php echo e((isset($category_type) && $category->id == $category_type) ? 'checked' : ''); ?> >
                            <label class="form-check-label d-flex justify-content-between" for="category<?php echo e($category->id); ?>">
                                <span><?php echo e($category->name); ?></span>
                                <span class="total">(<?php echo e($categoryCount ?? 0); ?>)</span>
                            </label>
                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if(count($categories) > 6): ?>
                    <li>
                        <a href="javascript:void(0)" class="show-more" data-list="categoryList" id="showMoreBtnCategory"><?php echo e(get_phrase('Show More')); ?></a>
                    </li>
                <?php endif; ?>
            </ul>
        </li>
        <li>
            <div class="accordion-item-range">
                <h4 class="title mb-3 capitalize"><?php echo e(get_phrase('Price')); ?></h4>
                <?php 
                    $selectedMinPrice = request()->input('min_price', $min_price); // Retain min price after filtering
                    $selectedMaxPrice = request()->input('max_price', $max_price); // Retain max price after filtering
                ?>
                <div id="price-slide" 
                    class="" 
                    data-min="<?php echo e($min_price); ?>" 
                    data-max="<?php echo e($max_price); ?>" 
                    data-start-min="<?php echo e($selectedMinPrice); ?>" 
                    data-start-max="<?php echo e($selectedMaxPrice); ?>">
                </div>
                <div class="accordion-range-value d-flex align-items-center justify-content-between">
                    <!-- Visible price inputs (updated to reflect selected values) -->
                    <input type="text" class="value" id="min-price" value="<?php echo e(currency()); ?><?php echo e($selectedMinPrice); ?>">
                    <input type="text" class="value text-end" id="max-price" value="<?php echo e(currency()); ?><?php echo e($selectedMaxPrice); ?>">
                    <!-- Hidden numeric inputs (updated to reflect selected values) -->
                    <input type="hidden" id="clean-min-price" name="min_price" value="<?php echo e($selectedMinPrice); ?>">
                    <input type="hidden" id="clean-max-price" name="max_price" value="<?php echo e($selectedMaxPrice); ?>">
                </div>
            </div>
        </li>
        <li class="sidebar-accordion-li">
            <a href="javascript:void(0);">
                <span><?php echo e(get_phrase('Type')); ?></span>
                <img src="<?php echo e(asset('assets/frontend/images/icons/angle-down-black-20.svg')); ?>" alt="">
            </a>
            <ul class="sidebar-accordion-menu">
                <?php
                    $statusCounts = DB::table('hotel_listings')
                        ->select('is_popular', DB::raw('COUNT(*) as total'))
                        ->groupBy('is_popular')
                        ->get()
                        ->keyBy('is_popular');
                ?>
            
                <!-- Sell Filter -->
                <li>
                    <a href="<?php echo e(route('ListingsFilter')); ?>?type=hotel&view=<?php echo e($view); ?>&status=top" 
                       class="filter <?php echo e((request()->get('is_popular') == 'top') ? 'active' : ''); ?>">
                        <label class="form-check-label d-flex justify-content-between">
                            <input class="d-none" type="radio" name="is_popular" value="top" <?php if($status_type == 'top'): ?> checked <?php endif; ?>>
                            <span><?php echo e(get_phrase('Top')); ?></span>
                            <span class="total">(<?php echo e($statusCounts['top']->total ?? 0); ?>)</span>
                        </label>
                    </a>
                </li>
            
                <!-- Rent Filter -->
                <li>
                    <a href="<?php echo e(route('ListingsFilter')); ?>?type=hotel&view=<?php echo e($view); ?>&status=popular" 
                       class="filter <?php echo e((request()->get('is_popular') == 'popular') ? 'active' : ''); ?>">
                        <label class="form-check-label d-flex justify-content-between">
                            <input class="d-none" type="radio" name="is_popular" value="popular"  <?php if($status_type == 'popular'): ?> checked <?php endif; ?>>
                            <span><?php echo e(get_phrase('Popular')); ?></span>
                            <span class="total">(<?php echo e($statusCounts['popular']->total ?? 0); ?>)</span>
                        </label>
                    </a>
                </li>
            </ul>
        </li>
        <li class="sidebar-accordion-li">
            <a href="javascript:void(0);">
                <span><?php echo e(get_phrase('Bedroom')); ?></span>
                <img src="<?php echo e(asset('assets/frontend/images/icons/angle-down-black-20.svg')); ?>" alt="">
            </a>
            <ul class="sidebar-accordion-menu" id="bedroomList">
                <?php $__currentLoopData = $numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                    <div class="d-flex align-items-center eCheck g-3">
                        <div class="form-check">
                            <input id="bedroom-<?php echo e($key); ?>" class="form-check-input" name="bed" type="radio"
                            value="<?php echo e($number); ?>" onchange="submitFilterForm()"
                            <?php if($searched_bedroom == $number): ?> checked <?php endif; ?>>
                     
                        </div>
                        <label for="bedroom-<?php echo e($key); ?>"><?php echo e($number); ?></label>
                    </div>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </li>
        <li class="sidebar-accordion-li">
            <a href="javascript:void(0);">
                <span><?php echo e(get_phrase('Bathroom')); ?></span>
                <img src="<?php echo e(asset('assets/frontend/images/icons/angle-down-black-20.svg')); ?>" alt="">
            </a>
            <ul class="sidebar-accordion-menu" id="bedroomList">
                <?php $__currentLoopData = $numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                    <div class="d-flex align-items-center eCheck g-3">
                        <div class="form-check">
                            <input id="bathroom-<?php echo e($key); ?>" class="form-check-input" name="bath" type="radio"
                                value="<?php echo e($number); ?>" onchange="submitFilterForm()"
                                <?php if($searched_bathroom == $number): ?> checked <?php endif; ?>>
                        </div>
                        <label for="bathroom-<?php echo e($key); ?>"><?php echo e($number); ?></label>
                    </div>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </li>
        <li class="sidebar-accordion-li">
            <a href="javascript:void(0);">
                <span><?php echo e(get_phrase('Country')); ?></span>
                <img src="<?php echo e(asset('assets/frontend/images/icons/angle-down-black-20.svg')); ?>" alt="">
            </a>
            <ul class="sidebar-accordion-menu" id="countriesList">
                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $countryName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
                    <?php
                        $country = App\Models\Country::where('id', $countryName->country)->first();
                        $countryCount = App\Models\HotelListing::where('country', $country->id)->count();
                    ?>
                    <li class="<?php echo e($index >= 6 ? 'hidden' : ''); ?>">
                        <a href="<?php echo e(route('ListingsFilter')); ?>?type=hotel&view=<?php echo e($view); ?>&country=<?php echo e($country->id); ?>" class="filter <?php echo e((isset($country_type) && $country->id == $country_type) ? 'active' : ''); ?>" for="country<?php echo e($country->id); ?>" >
                            <input class="d-none" type="radio" name="country" value="<?php echo e($country->id); ?>" id="country<?php echo e($country->id); ?>" <?php echo e((isset($country_type) && $country->id == $country_type) ? 'checked' : ''); ?> >
                            <label class="form-check-label d-flex justify-content-between" for="country<?php echo e($country->id); ?>">
                                <span><?php echo e($country->name); ?></span>
                                <span class="total">(<?php echo e($countryCount ?? 0); ?>)</span>
                            </label>
                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if(count($countries) > 6): ?>
                  <li><a href="javascript:void(0)" class="show-more" data-list="countriesList" ><?php echo e(get_phrase('Show More')); ?></a></li>
                <?php endif; ?>
            </ul>
        </li>
        <li class="sidebar-accordion-li">
            <a href="javascript:void(0);">
                <span><?php echo e(get_phrase('Cities')); ?></span>
                <img src="<?php echo e(asset('assets/frontend/images/icons/angle-down-black-20.svg')); ?>" alt="">
            </a>
            <ul class="sidebar-accordion-menu" id="cityList">
                <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
                    <?php
                        $city = App\Models\City::where('id', $item->city)->first();
                        $cityCount = App\Models\HotelListing::where('city', $city->id)->count();
                    ?>
                    <li class="<?php echo e($index >= 6 ? 'hidden' : ''); ?>">
                        <a href="<?php echo e(route('ListingsFilter')); ?>?type=hotel&view=<?php echo e($view); ?>&city=<?php echo e($city->id); ?>" class="filter <?php echo e((isset($city_type) && $city->id == $city_type) ? 'active' : ''); ?>" for="city<?php echo e($city->id); ?>" >
                            <input class="d-none" type="radio" name="city" value="<?php echo e($city->id); ?>" id="city<?php echo e($city->id); ?>" <?php echo e((isset($city_type) && $city->id == $city_type) ? 'checked' : ''); ?> >
                            <label class="form-check-label d-flex justify-content-between" for="city<?php echo e($city->id); ?>">
                                <span><?php echo e($city->name); ?></span>
                                <span class="total">(<?php echo e($cityCount ?? 0); ?>)</span>
                            </label>
                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if(count($cities) > 6): ?>
                  <li><a href="javascript:void(0)" class="show-more" data-list="cityList" ><?php echo e(get_phrase('Show More')); ?></a></li>
                <?php endif; ?>
            </ul>
        </li>
    </ul>
</form>


    <script src="<?php echo e(asset('assets/frontend/js/jquery-3.7.1.min.js')); ?>"></script>
    <script>
        "use strict";
        function submitFilterForm() {
            $('#filter-form').trigger('submit');
        }

     $('.filter').on('change click', function() {
         setTimeout(function() {
             $('#filter-form').trigger('submit');
         }, 200);  
     });
     
     function submitForm() {
         const minPriceInput = document.getElementById('min-price');
         const maxPriceInput = document.getElementById('max-price');
         const cleanMinPriceInput = document.getElementById('clean-min-price');
         const cleanMaxPriceInput = document.getElementById('clean-max-price');
         const currencySymbol = '<?php echo e(currency()); ?>'; 
     
         // Update hidden fields with numeric values
         cleanMinPriceInput.value = minPriceInput.value.replace(currencySymbol, '').trim();
         cleanMaxPriceInput.value = maxPriceInput.value.replace(currencySymbol, '').trim();
     
         // Temporarily remove "name" attributes from visible inputs
         minPriceInput.removeAttribute('name');
         maxPriceInput.removeAttribute('name');
     
         // Submit the form
       
         $('#filter-form').trigger('submit');

     
         // Restore "name" attributes after submission
         minPriceInput.setAttribute('name', 'display_min_price');
         maxPriceInput.setAttribute('name', 'display_max_price');
     }
     
     // Initialize the price slider
     var slider = document.getElementById('price-slide');
     var minPrice = parseInt(slider.getAttribute('data-min')) || 0;
     var maxPrice = parseInt(slider.getAttribute('data-max')) || 1000;
     var currentMinPrice = parseInt(document.getElementById('clean-min-price').value) || minPrice;
     var currentMaxPrice = parseInt(document.getElementById('clean-max-price').value) || maxPrice;
     
     noUiSlider.create(slider, {
         start: [currentMinPrice, currentMaxPrice],
         connect: true,
         range: {
             'min': minPrice,
             'max': maxPrice
         },
         tooltips: [true, true],
         format: {
             to: function (value) {
                 return '<?php echo e(currency()); ?>' + value.toFixed(0);
             },
             from: function (value) {
                 return Number(value.replace('<?php echo e(currency()); ?>', ''));
             }
         }
     });
     
     // Update visible and hidden fields when slider changes
     slider.noUiSlider.on('update', function (values) {
         document.getElementById('min-price').value = values[0];
         document.getElementById('max-price').value = values[1];
         document.getElementById('clean-min-price').value = values[0].replace('<?php echo e(currency()); ?>', '');
         document.getElementById('clean-max-price').value = values[1].replace('<?php echo e(currency()); ?>', '');
     });
     
     // Submit the form when the slider values change
     slider.noUiSlider.on('change', function () {
         submitForm();
     });
     
     
     
     
     </script>
     
     
<script>
    "use strict";
    function toggleList(button) {
    var listId = button.getAttribute('data-list');
    var list = document.getElementById(listId);
    var hiddenItems = list.querySelectorAll('.hidden');

    if (hiddenItems.length > 0) {
        hiddenItems.forEach(function(item) {
            item.classList.remove('hidden');
        });
        button.style.display = 'none';
    }
}

document.querySelectorAll('.show-more').forEach(function(button) {
    button.addEventListener('click', function() {
        toggleList(button);
    });
});

</script>

<script>
    "use strict";
    document.addEventListener('DOMContentLoaded', () => {
        const clearButton = document.querySelector('.clear');
        const urlParams = new URLSearchParams(window.location.search);
        const hasFilter = urlParams.has('category') ||urlParams.has('min_price') ;
        if (hasFilter) {
            clearButton.classList.remove('d-none'); 
            clearButton.classList.add('d-block');
        } else {
            clearButton.classList.remove('d-block');
            clearButton.classList.add('d-none');
        }
    });

    function resetForm(event) {
        event.preventDefault(); 
        const typeValue = document.querySelector('input[name="type"]').value;
        const viewValue = document.querySelector('input[name="view"]').value;
        // Build the new URL for redirection
        const baseUrl = "<?php echo e(route('listing.view', ['type' => ':type', 'view' => ':view'])); ?>";
        const newUrl = baseUrl.replace(':type', encodeURIComponent(typeValue))
                              .replace(':view', encodeURIComponent(viewValue));

        window.location.href = newUrl;
    }
</script>


<?php echo $__env->make('frontend.sidebar_bottom', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\v1\atlas\resources\views/frontend/hotel/sidebar_hotel.blade.php ENDPATH**/ ?>